# JottNote Changelog

## [1.1.0] - 2026-02-25

### Improved - Code Syntax Highlighting
- **Richer JSON highlighting** — Enhanced `highlightJSON()` to use 9 token classes instead of 5, utilizing all theme accent colors
  - Section keys (e.g. `"app"`, `"settings"`) now highlighted with function color (blue)
  - Colons highlighted with keyword color (purple) instead of plain punctuation
  - Array brackets `[]` highlighted with tag color (red) to differentiate from object braces `{}`
  - String values inside arrays highlighted with attribute color (gold) to differentiate from object string values

### Fixed - Code Mode Cursor Bug
- **Fixed cursor disappearing when reopening extension in code mode** — When `code:` (without a language) was typed and the extension was hidden/reopened, the editor textarea was pre-hidden but never restored, making text input impossible
  - Root cause: mismatch between `isCodeMode()` (returns true for `code:`) and `parseCodeKeyword()` (returns null for `code:` without a language name)
  - Fix: after `updateCodeMode()` runs, check if code-mode class was actually applied; if not, restore editor visibility

---

## [Unreleased] - 2026-01-23

### Added - Bookmark Manager Feature

#### Overview
Complete bookmark management system integrated into JottNote with keyword-based access, tag organization, search functionality, and Chrome bookmarks import.

#### New Files
- `js/bookmarks.js` - Core bookmark storage and CRUD operations
  - Bookmark schema with ID, URL, title, tags, description, timestamps
  - Chrome bookmarks import functionality
  - Tag management and filtering
  - Search across title, URL, tags, and description
  - Access time tracking for sorting

#### Modified Files

##### `manifest.json`
- Added `bookmarks` permission for Chrome bookmarks API access

##### `js/keywords.js`
- Added `bookmarks: 'bookmarks'` to DEFAULT_KEYWORDS (line 21)
- Added `parseBookmarksCommand()` function (line 335-383)
  - Detects bookmark commands: help, add, edit, filter, search, end
  - Parses tag filters and search queries
  - Extracts bookmark IDs for editing

##### `popup.html`
- Added bookmarks display overlay (line 260)
- Added bookmarks help guide with tag list (line 237-247)
- Added Chrome bookmarks import button in Misc settings (line 969-975)

##### `popup.css`
- Added complete bookmark UI styling (line 2956-3119)
  - Display overlay with keyword highlighting
  - Bookmark items with flexbox layout
  - Edit/delete buttons with hover effects
  - Tag filters and tag display
  - Truncated titles and URLs to prevent overflow
  - Empty state styling
  - Help guide styling

##### `popup.js`
- Added bookmark imports (line 22-32)
- Added state variables (line 172-188):
  - `bookmarksDisplay`, `bookmarksHelp`, `bookmarksTagsList`
  - `isAddingBookmark`, `isEditingBookmark`, `editingBookmarkId`
  - `bookmarksToSave`, `bookmarkEntryStep`, `currentBookmarkEntry`
- Added `updateBookmarksMode()` (line 3029-3097)
- Added `renderBookmarksDisplay()` (line 3099-3196)
- Added `populateTagsList()` (line 3200-3226)
- Added `handleBookmarkClick()` (line 3231-3240)
- Added `handleBookmarkEdit()` (line 3242-3269)
- Added `handleBookmarkDelete()` (line 3271-3304)
- Added `handleBookmarksAdd()` (line 3306-3330)
- Added `parseBookmarkFields()` (line 3332-3346)
- Added `insertBookmarkTemplate()` (line 3348-3383)
- Added `saveAllBookmarks()` (line 3385-3521)
  - Handles both add and edit modes
  - Updates existing bookmarks without creating duplicates
  - Preserves bookmark IDs during updates
- Updated `updateKeywordIndicator()` (line 1973-1986)
  - Shows "BOOKMARKS (⌘S to save)" in add mode
  - Shows "EDIT BOOKMARK (⌘S to save)" in edit mode
- Updated `updateEditorHighlighter()` (line 3506-3514)
  - Added bookmarks to Accent 3 color group (green)
  - Removed early return that hid text in add mode
- Updated keyboard handlers (line 4020-4099)
  - Enter key navigation through URL/Tags/Description fields
  - Cmd+S saves in add or edit mode
  - Escape cancels add or edit mode

#### Features

##### Keyword Commands
- `bookmarks` - Show help guide with all tags
- `bookmarks:add` - Enter guided add mode with auto-templates
- `bookmarks:search query` - Search bookmarks
- `bookmarks:tag` - Filter by specific tag (e.g., `bookmarks:work`)
- `bookmarks:edit:id` - Edit existing bookmark
- `bookmarks:end` or `bookmarks:save` - Save bookmarks in add mode

##### Add Mode (Guided Entry)
1. Type `bookmarks:add` and press Enter
2. System inserts `URL: ` template
3. Enter URL, press Enter → `Tags: ` template appears
4. Enter comma-separated tags, press Enter → `Description: ` template appears
5. Enter description, press Enter → Next bookmark template (or Cmd+S to save all)
6. Cmd+S saves all bookmarks, Escape cancels

##### Edit Mode
1. Search or filter bookmarks to find target
2. Hover over bookmark to reveal edit (✎) and delete (×) buttons
3. Click edit button → Loads bookmark into editor
4. Modify URL, Tags, or Description
5. Press Cmd+S to save changes (updates existing, no duplicates)
6. Press Escape to cancel

##### Delete
1. Hover over bookmark item
2. Click delete button (×)
3. Confirm deletion in dialog
4. Bookmark removed and view refreshed

##### Click to Open
- Click on bookmark content area to open URL in new tab
- Access time updated for sorting (most recent first)

##### Chrome Import
- Settings → Misc → "Import Chrome Bookmarks" button
- Imports all Chrome bookmarks
- Skips duplicates based on URL
- Preserves creation dates
- No tags initially (can be added via edit)

##### Tag System
- Comma-separated tags when adding/editing
- Clickable tag filters in help guide
- Tag counts displayed
- Case-insensitive filtering

##### Search
- Searches across title, URL, tags, and description
- Real-time results as you type query
- Shows "Search: 'query'" header

#### UI/UX Improvements
- Bookmark items with left accent border (green)
- Truncated titles with ellipsis for long text
- Edit/delete buttons fade in on hover
- Edit button turns green on hover
- Delete button turns red on hover
- Empty state message when no bookmarks found
- Keyword indicator shows current mode
- Editor highlighter properly managed (visible in add/edit, hidden in display modes)

#### Technical Details
- Bookmarks stored in Chrome local storage under `jottnote_bookmarks` key
- UUID generation for bookmark IDs
- ISO date strings for timestamps
- Bookmarks sorted by `accessedAt` (most recent first)
- Direct storage access in `saveBookmark()` to prevent filtered array issues
- Proper event propagation to separate content clicks from button clicks
- Console logging for debugging edit operations

#### Bug Fixes
- Fixed ghosting text overlay in search/filter modes
- Fixed text disappearing in add mode
- Fixed duplicate bookmarks during edit (now properly updates existing)
- Fixed long titles pushing edit/delete buttons off screen
- Fixed editor highlighter visibility in different bookmark modes
- Reserved tag keywords validation: Prevent using 'add', 'search', 'edit', 'end', 'save', 'help' as bookmark tags

### Added - Code Mode Improvements

#### Overview
Fixed cursor visibility, text selection, and overlay issues in code mode to provide a seamless syntax highlighting experience.

#### Modified Files

##### `popup.css`
- **Cursor Visibility** (line 3271)
  - Changed `caret-color` from `#fff` to `var(--text-primary)` for theme adaptation
  - Cursor now visible and adapts to all themes

- **Text Selection** (line 3285-3293)
  - Fixed `::selection` pseudo-element styling
  - Changed from `var(--accent-3-main)` with invalid `opacity` to `rgba(100, 150, 255, 0.3)`
  - Text selection now shows semi-transparent blue highlight

- **Code Editor Container** (line 3189)
  - Added solid background `var(--bg-primary)` to cover any content underneath
  - Prevents visual artifacts from showing through

- **Editor Highlighter Hiding** (line 3197-3206)
  - Added `!important`, `visibility: hidden`, and `opacity: 0` to completely hide editor-highlighter in code mode
  - Prevents double rendering and overlay conflicts

##### `popup.js`
- **Removed Dead Code** (line 716-722)
  - Removed undefined `codeDisplay` scroll sync that was causing console errors
  - Fixed: `Uncaught ReferenceError: codeDisplay is not defined`

- **Math Display Overlay Fix** (line 2794-2801)
  - Added check in `updateMathMode()` to skip processing when in code mode
  - Prevents CSS syntax (e.g., `max-width: 800px`) from being interpreted as math variables
  - Explicitly hides and clears math display when in code mode

- **Aggressive Code Mode Cleanup** (line 347-421)
  - Force exit code mode before loading new notes
  - Clear and recreate `code-highlight` element with forced DOM reflow
  - Hide code-editor-container during transitions to prevent flash of stale content
  - Clear all overlays (math, count, list, bookmarks, game, help guides) when loading notes
  - Use double `requestAnimationFrame` to ensure all rendering completes before showing container

- **Fresh DOM References** (line 2390-2423, line 3948-3972)
  - Always get fresh references to `code-highlight` element instead of using stale globals
  - Prevents issues where recreated elements aren't properly updated
  - Use `document.getElementById('code-highlight')` in `highlightCodeContent()`

- **Code Mode Entry** (line 2380-2409)
  - Explicitly hide math display when entering code mode
  - Clear editor-highlighter to prevent double display
  - Use `requestAnimationFrame` for smooth rendering
  - Reset scroll positions before and after highlighting

#### Bug Fixes
- **Fixed cursor disappearing in code mode** - Cursor now visible with theme-adaptive color
- **Fixed text selection not working** - Selection now shows semi-transparent highlight
- **Fixed overlay text from previous notes** - Math display (z-index: 4) was appearing above code editor (z-index: 3)
- **Fixed CSS being parsed as math** - Code syntax like `max-width: 800px` no longer triggers math variable parsing
- **Fixed stale highlighting when navigating between code notes** - Aggressive cleanup and fresh DOM references
- **Fixed console error** - Removed undefined `codeDisplay` reference
- **Fixed visual artifacts** - Solid background on code container covers any content underneath

#### Technical Details
- Math display has higher z-index (4) than code editor (3), so it was appearing on top
- CSS properties with colons (`:`) were being interpreted as math variable assignments
- Solution: Skip all math processing when `code-mode` class is active
- DOM reflow forced with `void codePre.offsetHeight` to ensure browser clears render tree
- Double `requestAnimationFrame` ensures two paint cycles complete before showing content

### Added - Theme System Enhancements

#### Overview
Updated all 14 themes to properly display 8 palette accent colors with correct color mappings from design specifications.

#### Modified Files

##### `js/themes.js`
- Added `--accent-6-main` to all 14 themes for complete 8-color palette
- Updated all theme colors to match spreadsheet specifications
- Theme structure now includes: bg-primary, text-primary, text-secondary, accent-1 through accent-6, border

##### `popup.js`
- **Theme Preview Dots** (line 4377-4382)
  - Changed from showing 8 random colors to showing correct 8 palette colors
  - Order: text-secondary, accent-1-main, accent-2-main, accent-3-main, accent-4-main, accent-5-main, accent-6-main, border
  - Ensures theme preview accurately represents the theme's color palette

##### `popup.css`
- **Theme Dot Sizing** (line 3444-3454)
  - Reduced dot size from 20px to 16px so all 8 colors fit on one line
  - Changed `flex-wrap: wrap` to `nowrap` to prevent wrapping
  - Dots remain inline and visible

- **Bookmarks Help Guide Colors** (line 3112-3147)
  - Changed base text color from `--text-secondary` to `--text-primary` for better visibility
  - Changed command text from non-existent `--accent-3-secondary` to `--accent-3-main`
  - Changed note text from `--text-muted` to `--text-secondary`
  - Fixed text blending with background in certain themes

#### Bug Fixes
- **Fixed only 7 palette colors showing** - Added missing `--accent-6-main` to all themes
- **Fixed theme dots wrapping to second line** - Reduced size and disabled wrapping
- **Fixed help text blending with background** - Updated color variables to proper theme-aware values

### Added - Search Panel Refinements

#### Overview
Refined search panel UI to match design specifications with smaller text, thinner search bar, keyword coloring by accent groups, and theme-aware styling for all themes.

#### Modified Files

##### `popup.css`
- **Search Bar Styling** (line 1487-1495)
  - Reduced height from 44px to 36px for more compact appearance
  - Changed background from fixed `rgba(255, 255, 255, 0.06)` to `var(--bg-secondary)` for theme adaptation
  - Added subtle `1px` border with `color-mix(in srgb, var(--text-primary) 10%, transparent)`
  - Reduced padding from 8px 16px to 6px 14px
  - Reduced border radius from 12px to 10px for sleeker look

- **Text Sizing** (line 1503-1523)
  - Input text reduced from 14px to 12px
  - Placeholder text reduced to 12px
  - All date/relative time text reduced from 13px to 11px
  - Preview text reduced from 14px to 11px

- **Search Results** (line 1540-1590)
  - Preview text uses `var(--text-muted)` that changes to `var(--text-primary)` on hover
  - Added smooth color transitions (0.15s ease)
  - Reduced item padding from 16px to 12px for more compact layout
  - Font weight set to 400 for lighter appearance

- **Keyword Accent Coloring** (line 1567-1590)
  - Math/Currency: `var(--accent-1-main)` (blue)
  - List/Template: `var(--accent-2-main)` (purple)
  - Sum/Paste/Bookmarks: `var(--accent-3-main)` (green)
  - Avg/Code/Timer: `var(--accent-4-main)` (lime)
  - Count/Sort: `var(--accent-5-main)` (orange)
  - Keywords displayed with font-weight: 600 for emphasis

##### `popup.js`
- **Updated `extractKeyword()`** (line 1684-1697)
  - Returns full first line including optional titles (e.g., "list: Optional Title")
  - Added all keyword types: bookmarks, template, currency, paste, sort

- **Updated `performSearch()`** (line 1764-1817)
  - Keywords now wrapped in CSS classes based on mode for accent coloring
  - Keywords displayed on separate line from preview content
  - Uses `parseKeyword()` to determine mode for proper accent color assignment
  - Keywords shown as `<span class="search-keyword-{mode}">`

#### Features
- **Theme-Aware Search Bar**: Adapts to both light and dark themes with proper contrast
- **Keyword Coloring**: Each keyword type displays in its corresponding accent color
- **Hover Effects**: Search result text transitions from muted to primary color on hover
- **Compact Design**: Smaller text and thinner search bar for refined appearance
- **Improved Visibility**: Border ensures search bar is visible on all theme backgrounds

#### Bug Fixes
- **Fixed search bar invisible on light themes** - Changed from fixed rgba to theme-aware `var(--bg-secondary)` with border
- **Fixed keyword colors not displaying** - Added accent group CSS classes for each keyword type
- **Fixed text too large** - Reduced all text sizes to 11-12px for refined look

---

## Version History

### Future Releases
- Bookmark folders/categories
- Bookmark sync across devices
- Bulk operations (select multiple, batch delete, batch tag edit)
- Export bookmarks to file
- Import bookmarks from file/other browsers
- Bookmark sorting options (alphabetical, by date, by tag)
